/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.serialization.Lifecycle;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.LevelVersion;
import org.apache.commons.lang3.StringUtils;

public class LevelSummary
implements Comparable<LevelSummary> {
    private final LevelSettings f_78344_;
    private final LevelVersion f_78345_;
    private final String f_78346_;
    private final boolean f_193019_;
    private final boolean f_78348_;
    private final File f_78349_;
    @Nullable
    private Component f_78350_;

    public LevelSummary(LevelSettings p_78352_, LevelVersion p_78353_, String p_78354_, boolean p_78355_, boolean p_78356_, File p_78357_) {
        this.f_78344_ = p_78352_;
        this.f_78345_ = p_78353_;
        this.f_78346_ = p_78354_;
        this.f_78348_ = p_78356_;
        this.f_78349_ = p_78357_;
        this.f_193019_ = p_78355_;
    }

    public String m_78358_() {
        return this.f_78346_;
    }

    public String m_78361_() {
        return StringUtils.isEmpty((CharSequence)this.f_78344_.m_46917_()) ? this.f_78346_ : this.f_78344_.m_46917_();
    }

    public File m_78362_() {
        return this.f_78349_;
    }

    public boolean m_193020_() {
        return this.f_193019_;
    }

    public long m_78366_() {
        return this.f_78345_.m_78392_();
    }

    @Override
    public int compareTo(LevelSummary p_78360_) {
        if (this.f_78345_.m_78392_() < p_78360_.f_78345_.m_78392_()) {
            return 1;
        }
        return this.f_78345_.m_78392_() > p_78360_.f_78345_.m_78392_() ? -1 : this.f_78346_.compareTo(p_78360_.f_78346_);
    }

    public LevelSettings m_164913_() {
        return this.f_78344_;
    }

    public GameType m_78367_() {
        return this.f_78344_.m_46929_();
    }

    public boolean m_78368_() {
        return this.f_78344_.m_46930_();
    }

    public boolean m_78369_() {
        return this.f_78344_.m_46932_();
    }

    public MutableComponent m_78370_() {
        return StringUtil.m_14408_((String)this.f_78345_.m_78393_()) ? new TranslatableComponent("selectWorld.versionUnknown") : new TextComponent(this.f_78345_.m_78393_());
    }

    public LevelVersion m_78371_() {
        return this.f_78345_;
    }

    public boolean m_78372_() {
        return this.m_78373_() || !SharedConstants.m_183709_().isStable() && !this.f_78345_.m_78395_() || this.m_164914_().m_164931_();
    }

    public boolean m_78373_() {
        return this.f_78345_.m_193029_().m_193006_() > SharedConstants.m_183709_().m_183476_().m_193006_();
    }

    public BackupStatus m_164914_() {
        WorldVersion worldversion = SharedConstants.m_183709_();
        int i = worldversion.m_183476_().m_193006_();
        int j = this.f_78345_.m_193029_().m_193006_();
        if (!worldversion.isStable() && j < i) {
            return BackupStatus.UPGRADE_TO_SNAPSHOT;
        }
        return j > i ? BackupStatus.DOWNGRADE : BackupStatus.NONE;
    }

    public boolean m_78375_() {
        return this.f_78348_;
    }

    public boolean m_164916_() {
        if (!this.m_78375_() && !this.m_193020_()) {
            return !this.m_193021_();
        }
        return true;
    }

    public boolean m_193021_() {
        return SharedConstants.m_183709_().m_183476_().m_193003_(this.f_78345_.m_193029_());
    }

    public Component m_78376_() {
        if (this.f_78350_ == null) {
            this.f_78350_ = this.m_78377_();
        }
        return this.f_78350_;
    }

    private Component m_78377_() {
        TranslatableComponent mutablecomponent;
        if (this.m_78375_()) {
            return new TranslatableComponent("selectWorld.locked").m_130940_(ChatFormatting.RED);
        }
        if (this.m_193020_()) {
            return new TranslatableComponent("selectWorld.conversion").m_130940_(ChatFormatting.RED);
        }
        if (!this.m_193021_()) {
            return new TranslatableComponent("selectWorld.incompatible_series").m_130940_(ChatFormatting.RED);
        }
        TranslatableComponent translatableComponent = mutablecomponent = this.m_78368_() ? new TextComponent("").m_7220_((Component)new TranslatableComponent("gameMode.hardcore").m_130940_(ChatFormatting.DARK_RED)) : new TranslatableComponent("gameMode." + this.m_78367_().m_46405_());
        if (this.m_78369_()) {
            mutablecomponent.m_130946_(", ").m_7220_((Component)((Object)new TranslatableComponent("selectWorld.cheats")));
        }
        MutableComponent mutablecomponent1 = this.m_78370_();
        MutableComponent mutablecomponent2 = new TextComponent(", ").m_7220_((Component)((Object)new TranslatableComponent("selectWorld.version"))).m_130946_(" ");
        if (this.m_78372_()) {
            mutablecomponent2.m_7220_((Component)mutablecomponent1.m_130940_(this.m_78373_() ? ChatFormatting.RED : ChatFormatting.ITALIC));
        } else {
            mutablecomponent2.m_7220_((Component)mutablecomponent1);
        }
        mutablecomponent.m_7220_((Component)mutablecomponent2);
        return mutablecomponent;
    }

    public boolean isExperimental() {
        return this.f_78344_.getLifecycle().equals(Lifecycle.experimental());
    }

    public static final class BackupStatus
    extends Enum<BackupStatus> {
        public static final /* enum */ BackupStatus NONE = new BackupStatus(false, false, "");
        public static final /* enum */ BackupStatus DOWNGRADE = new BackupStatus(true, true, "downgrade");
        public static final /* enum */ BackupStatus UPGRADE_TO_SNAPSHOT = new BackupStatus(true, false, "snapshot");
        private final boolean f_164920_;
        private final boolean f_164921_;
        private final String f_164922_;
        private static final /* synthetic */ BackupStatus[] $VALUES;

        public static BackupStatus[] values() {
            return (BackupStatus[])$VALUES.clone();
        }

        public static BackupStatus valueOf(String p_164936_) {
            return Enum.valueOf(BackupStatus.class, p_164936_);
        }

        private BackupStatus(boolean p_164928_, boolean p_164929_, String p_164930_) {
            this.f_164920_ = p_164928_;
            this.f_164921_ = p_164929_;
            this.f_164922_ = p_164930_;
        }

        public boolean m_164931_() {
            return this.f_164920_;
        }

        public boolean m_164932_() {
            return this.f_164921_;
        }

        public String m_164933_() {
            return this.f_164922_;
        }

        private static /* synthetic */ BackupStatus[] m_164934_() {
            return new BackupStatus[]{NONE, DOWNGRADE, UPGRADE_TO_SNAPSHOT};
        }

        static {
            $VALUES = BackupStatus.m_164934_();
        }
    }
}

